/*
 * Decompiled with CFR 0.152.
 */
package teamdraco.unnamedanimalmod.common.block;

import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class DriedMudBlock
extends Block {
    private final BlockState solidifiedState;

    public DriedMudBlock(BlockState solidifiedState, AbstractBlock.Properties properties) {
        super(properties);
        this.solidifiedState = solidifiedState;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState blockstate;
        BlockPos blockpos;
        World iblockreader = context.func_195991_k();
        return DriedMudBlock.shouldSolidify((IBlockReader)iblockreader, blockpos = context.func_195995_a(), blockstate = iblockreader.func_180495_p(blockpos)) ? this.solidifiedState : super.func_196258_a(context);
    }

    private static boolean shouldSolidify(IBlockReader reader, BlockPos pos, BlockState state) {
        return DriedMudBlock.causesSolidify(state) || DriedMudBlock.isTouchingLiquid(reader, pos);
    }

    private static boolean isTouchingLiquid(IBlockReader reader, BlockPos pos) {
        boolean flag = false;
        BlockPos.Mutable blockpos$mutable = pos.func_239590_i_();
        for (Direction direction : Direction.values()) {
            BlockState blockstate = reader.func_180495_p((BlockPos)blockpos$mutable);
            if (direction == Direction.DOWN && !DriedMudBlock.causesSolidify(blockstate)) continue;
            blockpos$mutable.func_239622_a_((Vector3i)pos, direction);
            blockstate = reader.func_180495_p((BlockPos)blockpos$mutable);
            if (!DriedMudBlock.causesSolidify(blockstate) || blockstate.func_224755_d(reader, pos, direction.func_176734_d())) continue;
            flag = true;
            break;
        }
        return flag;
    }

    private static boolean causesSolidify(BlockState state) {
        return state.func_204520_s().func_206884_a((ITag)FluidTags.field_206959_a);
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        return DriedMudBlock.isTouchingLiquid((IBlockReader)worldIn, currentPos) ? this.solidifiedState : super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }
}

